// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for extracting and deleting files from a packed file.
//.................................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	BOOL				bIsWin95;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	LPCTSTR				lpszNullString;
extern	LPCTSTR				lpszPacked;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	TCHAR				szFileName[MAX_PATH];
extern	HANDLE				hInputFile;
extern	HANDLE				hOutPutFile;
extern	PACKED_FILE_ID_HDR	pfidhdr;
extern	PACKED_FILE_HEADER	pfhdr;
extern	LPPACKED_FILE_DIR	lppfd;
extern	BYTE				PackedFileId[4];
extern	BYTE				PackedFileId1[4];
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HWND				hEditListWindow;
extern	BOOL				bEditWindowDisplayed;
extern	HWND				hEditWindow;
extern	HANDLE				hPackedEvent;
extern	HANDLE				hPackedOpen;
extern	LPCTSTR				lpszTscPacked;
extern	DWORD				dwHeaderSize;
extern	DWORD				szDestination[MAX_PATH];
extern	LPBYTE				lpAppendPtr;
extern	LPBYTE				lpAppendExt;
extern	int					iWhichAviClip;
extern	int					iStepIncrement;
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	int					iMaxItems;
extern	int					iItemsSelected;
extern	int					iItemCount;
extern	LPPACKED_FILE_DIR	lppfdScratch;
extern	HICON				hIcon2;
extern	HICON				hIcon;
extern	int					iNumberOfFiles;
extern	LPBYTE				lpInBuffer;
extern	LPBYTE				lpOutBuffer;
extern	TCHAR				szBackUpFile[MAX_PATH];
extern	HANDLE				hBackUpFile;
extern	ULARGE_INTEGER		uliFinalFileSize;
extern	LPBYTE				lpDestinationFileName;
extern	BOOL				bOverWriteAll;
extern	DWORD				dwCheckCrc32;
extern	int					iFilesUnpacked;
extern	LPBYTE				lpCodeTable;
extern	DWORD				dwCodeTableSize;
extern	LPBYTE				lpPStack;
extern	DWORD				dwPStackSize;
extern	DWORD				dwPassCrc32;
extern	CODE_STATS			CodeStats;
extern	int					iMaxUnpack;
extern	LPBYTE				lpCrc32Table;
extern	LARGE_INTEGER		liHalfPercent;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	SHFILEINFO			shfi1;
extern	BOOL				bUseNew;
extern	BOOL				bViewOnly;
extern	BOOL				bWeHaveLzw;
extern	TCHAR				szPreviousDestinationDir[MAX_PATH];
extern	DWORD				dwTip;
extern	DWORD				dwTipString;
extern	HFONT				hDlgFont;
extern	CONFIG				cfg;

// Variables for the extract and delete procedures.
//.................................................
int				iFilesToProcess;
BOOL			bExtract;
TCHAR			szExtResults[] = "Files to extract: %d. %u out of %u extracted files passed their integrity checks.";

// Procedure for selecting the files to extract or delete from
// a packed file. If bExtract is TRUE we extract files from a
// packed file. If bExtract is FALSE we delete files from a
// packed file.
//............................................................
VOID PackedFileProc()
{
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	ULARGE_INTEGER		uli;
	ULARGE_INTEGER		uliScratch1;
	LARGE_INTEGER		liStats;
	OPENFILENAME		ofn;
	BOOL				bResult;
	LONG				lResult;
	int					iResult;
	HRESULT				hr = ERROR_SUCCESS;
	int					iTotalFiles;
	DWORD				dwBytesRead;
	DWORD				dwBytesToRead;
	DWORD				dwBytesWritten;
	DWORD				dwOldHelpTopic;
	DWORD				dwDestinationLength;
	DWORD				dwLastError;
	BOOL				bDiskError = TRUE;
	BOOL				bAllDeleted = FALSE;
	BROWSEINFO			bi;
    LPITEMIDLIST		lpidl;
    LPMALLOC			lpMalloc;
	UINT				uiDriveType;
	RECT				rect;
	TCHAR				szRoot[16];
	TCHAR				szFormat[256];
	TCHAR				szOutBuffer[512];
	TCHAR				szPackedFileName[MAX_PATH];

	bProcessInProgress = TRUE;

	if (bExtract)
	{
		dwOldHelpTopic = IDH_EXTRACTPACKED;
	}
	else
	{
		dwOldHelpTopic = IDH_DELETE;
	}
	dwOldHelpTopic = ChangeHelpTopic(dwOldHelpTopic);
	bViewOnly = FALSE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = sizeof(szFileName);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;

	// Setup the title depending on the function.
	//...........................................
	if (bExtract)
	{
		ofn.lpstrTitle = TEXT("Select a Packed File to Extract Files From");
	}
	else
	{
		ofn.lpstrTitle = TEXT("Select a Packed File to Delete Files From");
	}

	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szFileName,sizeof(szFileName));

		// Select the packed file to add files to.
		//........................................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto ExtractEnd;
		}
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);

		// Make sure the file is a valid packed file.
		//...........................................
		lpFileName = PathFindFileName((LPCTSTR)&szFileName);
		lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);

		hInputFile = IsValidPackedFile((LPBYTE)&szFileName,TRUE);

		if (hInputFile)
		{
			break;
		}
	}
	EmptyTheMessageQue();

	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	// If we are extracting, we have to get a destination to extract
	// the files into.
	//..............................................................
	if (bExtract)
	{
		while(TRUE)
		{
			SetCurrentDirectory((LPCTSTR)&szPreviousDestinationDir);
			ZeroMemory(&szDestination,sizeof(szDestination));

			if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
			{
				ZeroMemory(&bi,sizeof(bi));
				bi.hwndOwner = hMainWindow;
				bi.pszDisplayName = 0;
				bi.lpszTitle = TEXT("Select a Destination for the extracted file(s).");
				bi.pidlRoot = 0;
				bi.ulFlags = BIF_RETURNONLYFSDIRS;

				// If we can use the new style of the dialog box, do it.
				//......................................................
				if (bUseNew)
				{	
					hr = CoInitialize(NULL);
					if (SUCCEEDED(hr))
					{
						bi.ulFlags |= BIF_NEWDIALOGSTYLE;
					}
				}
				bi.lpfn = BrowseCallbackProc;

				lpidl = SHBrowseForFolder(&bi);

				if (bUseNew && SUCCEEDED(hr))
				{
					CoUninitialize();
				}
				if (lpidl) 
				{
					bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
					lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
					lpMalloc->lpVtbl->Release(lpMalloc);
				}
				else
				{
					// We cancelled out.
					//..................
					goto ExtractEnd;
				}
				SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,FALSE);

				// See if we have any free disk space. cd rom drives that
				// are not writable will report zero.
				//.......................................................
				ZeroMemory(&szRoot,sizeof(szRoot));
				CopyMemory(&szRoot,&szDestination,3);
				bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
											(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
											(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					goto ExtractEnd;
				}
				if (uliFreeCallerBytes.QuadPart == 0)
				{
					SetLastError(IDS_NOSPACE);
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					continue;
				}
				if (uliFreeCallerBytes.QuadPart < 
					pfidhdr.uliTotalSizeOfFiles.QuadPart)
				{
					SetLastError(IDS_INSUFFICIENTSPACE);
					ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
					continue;
				}
				// Get the drive type so we can determine which avi
				// clip to use.
				//.................................................
				uiDriveType = GetDriveType((LPCTSTR)&szRoot);

				// If we got this far with no error, we have a valid
				// destination.
				//..................................................
				break;
			}
			else
			{
				MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
							   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto ExtractEnd;
			}
		}
		// Add a backslash to the destination if we need one.
		//...................................................
		lpAppendPtr = PathAddBackslash((LPTSTR)&szDestination);
		dwDestinationLength = lstrlen((LPCTSTR)&szDestination);

		// Setup the avi clip we will use.
		//................................
		iWhichAviClip = FILE_COPY;
		if (uiDriveType == DRIVE_REMOVABLE && (*szDestination == 0x41 ||
			*szDestination == 0x61 || *szDestination == 0x42 ||
			*szDestination == 0x62))
		{
			iWhichAviClip = FILE_DISK;
		}
		else if (uiDriveType == DRIVE_CDROM)
		{
			iWhichAviClip = FILE_CDROM;
		}
	}
	if (!bExtract)
	{
		iWhichAviClip = FILE_NUKE;
	}
	// Build the crc32 table.
	//.......................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto ExtractEnd;
	}
	// Create the central directory for the packed file.
	//..................................................
	bResult = BuildPackedFileCentralDir((LPBYTE)&szFileName,hInputFile);
	if (!bResult)
	{
		goto ExtractEnd;
	}
	// Rewind the packed file to point to the first file header.
	//..........................................................
	uli.QuadPart = sizeof(PACKED_FILE_ID_HDR);
	uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,uli.QuadPart,FILE_BEGIN);
	if (uli.QuadPart == -1)
	{
		goto ExtractEnd;
	}
	// Setup a few variables for the selection process.
	//.................................................
	iItemsSelected = 0;
	iItemCount = pfidhdr.iFilesInVault;
	iMaxItems = pfidhdr.iFilesInVault;
	lppfdScratch = lppfd;

	// Create our event for deleting or extracting file from a
	// packed file.
	//.........................................................
	hPackedEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("PackedEvent"));
	if (!hPackedEvent)
	{
		ErrorProcedure(TEXT("PackedEvent"),IDS_CREATEEVENT,MB_OK);
		goto ExtractEnd;
	}
	// Create the window to display the packed file contents in.
	// Use hEditWindow and bEditWindowDisplayed
	//..........................................................
	GetClientRect(hMainWindow,&rect);

	hEditWindow = CreateWindowEx(0,lpszTscPacked,lpszNullString,
								 WS_CAPTION | WS_CHILD | WS_SYSMENU | 
								 WS_VISIBLE | WS_CLIPCHILDREN,rect.left,rect.top+37,
								 rect.right,rect.bottom-59,hMainWindow,NULL,hInst,NULL);

	if (!hEditWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto ExtractEnd;
	}
	// Open the event object.
	//.......................
	hPackedOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("PackedEvent"));
	if (!hPackedOpen)
	{
		DestroyWindow(hEditWindow);
		goto ExtractEnd;
	}
	// Only display the tip if we have not stopped it.
	//................................................
	if (cfg.dwTips & PACK_TIP)
	{
		dwTip = PACK_TIP;
		dwTipString = IDS_PACK_TIP;
		PostMessage(hEditWindow,WM_TIP,0,0);
	}
	// We have to wait for the Packed Event to become signaled 
	// before we can return.
	//........................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hPackedEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}
	if (hPackedOpen)
	{
		CloseHandle(hPackedOpen);
		hPackedOpen = 0;
	}
	if (hPackedEvent)
	{
		CloseHandle(hPackedEvent);
		hPackedEvent = 0;
	}
	// If we did not select any items, lets get out of here.
	//......................................................
	if (iItemsSelected == 0)
	{
		goto ExtractEnd;
	}
	iNumberOfFiles = pfidhdr.iFilesInVault;
	iTotalFiles = iNumberOfFiles;

	// If we are extracting files, get the total size of the files
	// that we will be extracting for the progress bar.
	//............................................................
	if (bExtract)
	{
		lppfdScratch = lppfd;
		uliScratch1.QuadPart = 0;

		while(iNumberOfFiles > 0)
		{
			if (lppfdScratch->STATE)
			{
				uliScratch1.QuadPart += lppfdScratch->pfh.uliCompressedFileSize.QuadPart ;
			}
			__asm
			{
				mov		eax,dwHeaderSize
				add		lppfdScratch,eax
			}
			iNumberOfFiles--;
		}
		iNumberOfFiles = iTotalFiles;

		// Determine what is a half percent for updating the progress bar.
		//................................................................
		if (uliScratch1.QuadPart < 40000)
		{
			__asm
			{
				xor		edx,edx
				mov		eax,uliScratch1.LowPart
				mov		ecx,200
				div		ecx
				cmp		eax,edx
				jae		L2
				inc		eax
			L2:	mov		liHalfPercent.HighPart,0
				mov		liHalfPercent.LowPart,eax
			}
		}
		else
		{
			liHalfPercent.QuadPart = (uliScratch1.QuadPart / 200);
	
			if (liHalfPercent.QuadPart == 0)
			{
				liHalfPercent.QuadPart = 1;
			}
		}
		liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;
	}
	// Setup the input and output buffers.
	//....................................
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto ExtractEnd;
	}
	// Extract files.
	//...............
	if (bExtract)
	{
		// Reassign a couple of variables.
		//................................
		iFilesToProcess = iNumberOfFiles;
		iNumberOfFiles = iItemsSelected;

		// We only have selected files to extract from the
		// packed file. Setup the modeless dialog box for
		// unpacking our files.
		//...............................................
		bCancelOperation = FALSE;
		hDialogModeLess = CreateDialog(hInst,TEXT("EXTRACTPACKEDFILES"),hMainWindow,
									  (DLGPROC)ExtractPackedFilesProc);
		if (!hDialogModeLess)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto ExtractEnd;
		}
		// Start the avi clip.
		//....................
		if (bAviClipOK)
		{
			bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
		}
		lppfdScratch = lppfd;
		dwPassCrc32 = 0;
		iFilesUnpacked = 0;

		while(iFilesToProcess > 0)
		{
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				goto ExtractEnd;
			}
			ZeroMemory(&szPackedFileName,MAX_PATH);

			// Get the icon for the file we are processing.
			//.............................................
			if (hIcon)
			{
				DestroyIcon(hIcon);
				hIcon = 0;
			}
			lpFileExtension = PathFindExtension((LPCTSTR)lppfdScratch->FileName);
			hIcon = FindMyIcon((LPBYTE)lppfdScratch->FileName,lpFileExtension);
			
			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			// Read in the file header and file name.
			//.......................................
			bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfhdr,
								  sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);

			// If we did not read in the required number of bytes.
			//....................................................
			if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
			{
				SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
				ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
				goto ExtractEnd;
			}
			if (!bResult)
			{
				goto ExtractEnd;
			}
			// Read the file name.
			//....................
			bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
								 &szPackedFileName,pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

			// If we did not read in the required number of bytes.
			//....................................................
			if (dwBytesRead != pfhdr.wLengthOfFileName)
			{
				SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
				ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
				goto ExtractEnd;
			}
			if (!bResult)
			{
				goto ExtractEnd;
			}
			// Check to see if we extract this file or not.
			//.............................................
			if (lppfdScratch->STATE == 0)
			{
				// We do not extract this file. Get past the
				// compressed data to the next file header.
				//..........................................
				uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
												 pfhdr.uliCompressedFileSize.QuadPart,
												 FILE_CURRENT);
				if (uli.QuadPart == -1)
				{
					goto ExtractEnd;
				}
			}
			else
			{
				// We extract this file. Setup the destination file name.
				// First check to see if the file name fits.
				//.......................................................
				if ((dwDestinationLength + pfhdr.wLengthOfFileName) > MAX_PATH)
				{
					SetLastError(IDS_PATHTOOLONGUNPACK);
					ErrorProcedure((LPTSTR)&szPackedFileName,IDS_CREATE_OPEN,MB_OK);

					// We have to get past the compressed data to the next
					// file header.
					//....................................................
					uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
													 pfhdr.uliCompressedFileSize.QuadPart,
													 FILE_CURRENT);
					if (uli.QuadPart == -1)
					{
						goto ExtractEnd;
					}
					goto NextFile;
				}
				// Create the output file name.
				//.............................
				*lpAppendPtr = 0;
				StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),
							  (LPCTSTR)&szPackedFileName,NULL,NULL,dwStringSafeFlag);

				// Create the file. If it exists in the destination ask if
				// we want to overwrite.
				//........................................................
				hOutPutFile = CreateFile((LPCTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,
										  0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);

				if (hOutPutFile == INVALID_HANDLE_VALUE)
				{
					hOutPutFile = 0;

					dwLastError = GetLastError();
					if (dwLastError == ERROR_FILE_EXISTS)
					{
						if (!bOverWriteAll)
						{
							FlashMyIcon(FALSE);

							// Ask if we want to override.
							//............................
							iResult = DialogBox(hInst,TEXT("ASKOVERWRITE"),hDialogModeLess,
											   (DLGPROC)AskOverwriteUnpackProc);

							// See if we had a system error in creating
							// the dialog box.
							//.........................................
							if (iResult == -1)
							{
								ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
								goto ExtractEnd;
							}
							// Quit if we canceled.
							//.....................
							if (iResult == IDCANCEL)
							{
								goto ExtractStats;
							}
							// No, do not overwrite this file.
							//................................
							if (iResult == IDC_MYNO)
							{
								// We have to get past the compressed
								// data to the next file header.
								//...........................................
								uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
																 pfhdr.uliCompressedFileSize.QuadPart,
																 FILE_CURRENT);
								if (uli.QuadPart == -1)
								{
									goto ExtractEnd;
								}
								goto NextFile;
							}
						}
						// We want to overwrite the file.
						// Check to see if we can unpack this file before we delete it.
						//.............................................................
						if (bWeHaveLzw)
						{
							SetMaxCodeSizeOnStartUp();
							if (pfhdr.LargestBitCode <= iMaxUnpack)
							{
								hOutPutFile = CreateMyFile((LPTSTR)&szDestination,
															GENERIC_READ | GENERIC_WRITE,
															0,NULL,TRUNCATE_EXISTING,
															FILE_ATTRIBUTE_NORMAL,NULL);
								if (!hOutPutFile)
								{
									goto ExtractEnd;
								}
							}
						}
						else
						{
							hOutPutFile = CreateMyFile((LPTSTR)&szDestination,
														GENERIC_READ | GENERIC_WRITE,
														0,NULL,TRUNCATE_EXISTING,
														FILE_ATTRIBUTE_NORMAL,NULL);
							if (!hOutPutFile)
							{
								goto ExtractEnd;
							}
						}
					}
					else
					{
						SetLastError(dwLastError);
						ErrorProcedure((LPTSTR)&szDestination,IDS_CREATE_OPEN,MB_OK);
						goto ExtractEnd;
					}
				}
				bDiskError = TRUE;

				// We have a valid output file. Check to see if the file
				// is just stored or compressed.
				//......................................................
				if (pfhdr.LargestBitCode == 0)
				{
					// Setup the name and icon of the file to decompress.
					//...................................................
					if (hIcon2)
					{
						DestroyIcon(hIcon2);
					}
					hIcon2 = hIcon;
					hIcon = 0;
					SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,
							   (WPARAM)hIcon2,0);

					SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
									 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

					EmptyTheMessageQue();

					dwCheckCrc32 = -1;
					uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;
					liStats.QuadPart = 0;
			
					while(uli.QuadPart > 0)
					{
						if (uli.QuadPart > BUFFER_SIZE_IN)
						{
							dwBytesToRead = BUFFER_SIZE_IN;
							uli.QuadPart -= BUFFER_SIZE_IN;
						}
						else
						{
							dwBytesToRead = uli.LowPart;
							uli.QuadPart = 0;
						}
						bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
											  lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);

						// If we did not read in the required number of 
						// bytes.
						//.............................................
						if (dwBytesRead != dwBytesToRead)
						{
							SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
							ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
							goto ExtractEnd;
						}
						if (!bResult)
						{
							goto ExtractEnd;
						}
						// Calculate the crc32 check value.
						//.................................
						__asm
						{
							mov		edi,lpInBuffer
							mov		ecx,dwBytesRead
						L1:	mov		al,byte ptr [edi]
							xor		al,byte ptr dwCheckCrc32
							shr		dwCheckCrc32,8
							movzx	esi,al
							mov		ebx,lpCrc32Table
							mov		edx,dword ptr [ebx][esi*4]
							xor		dwCheckCrc32,edx
							inc		edi
							dec		ecx
							jnz		L1
						}
						// Write the input buffer to the destination file.
						//................................................
						bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,lpInBuffer,
											  dwBytesRead,&dwBytesWritten,NULL);
						if (!bResult)
						{
							goto ExtractEnd;
						}
						// Update the status bar to reflect this file.
						//............................................
						liStats.QuadPart += dwBytesRead;
						while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
						{
							SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),
										PBM_STEPIT,0,0);
							liStats.QuadPart -= liHalfPercentDup.QuadPart;
						}
					}
				}
				else
				{
					// Check to see if we can unpack this file.
					//.........................................
					if (bWeHaveLzw)
					{
						SetMaxCodeSizeOnStartUp();
						if (pfhdr.LargestBitCode > iMaxUnpack)
						{
							SetLastError(IDS_NOTENOUGHMEMORYTOUNPACK);
							lResult = ErrorProcedure((LPTSTR)&szDestination,
													  IDS_ALLOCATEMEMORY,MB_OKCANCEL);
							if (lResult == IDCANCEL)
							{
								goto ExtractEnd;
							}
							// We have to get past the compressed data to
							// the next file header.
							//...........................................
							uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,
															 hInputFile,
															 pfhdr.uliCompressedFileSize.QuadPart,
															 FILE_CURRENT);
							if (uli.QuadPart == -1)
							{
								goto ExtractEnd;
							}
							// Close and delete the output file we just
							// created.
							//.........................................
							bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
							if (!bResult)
							{
								goto ExtractEnd;
							}
							hOutPutFile = 0;

							bResult = DeleteMyFile((LPTSTR)&szDestination);
							if (!bResult)
							{
								goto ExtractEnd;
							}
							bDiskError = FALSE;
							goto NextFile;
						}
					}
					// Setup the name and icon of the file to decompress.
					//...................................................
					if (hIcon2)
					{
						DestroyIcon(hIcon2);
					}
					hIcon2 = hIcon;
					hIcon = 0;
					SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,
							   (WPARAM)hIcon2,0);

					SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
									 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

					EmptyTheMessageQue();

					// Allocate the extended memory as required for each
					// file as it is to be unpacked.
					//..................................................
					if (bWeHaveLzw)
					{
						SetLzwParameters((LPCODE_STATS)&CodeStats,pfhdr.LargestBitCode);
						lpCodeTable = AllocateMemory(dwCodeTableSize);
						lpPStack = AllocateMemory(dwPStackSize);
						if (!lpCodeTable || !lpPStack)
						{
							goto ExtractEnd;
						}
						// Decompress the file.
						//.....................
						bResult = DecompressTheFile((LPBYTE)&szFileName,hInputFile,
												   (LPBYTE)&szDestination,hOutPutFile);
						if (!bResult)
						{
							goto ExtractEnd;
						}
						// We are done with this file. Deallocate the memory
						// for the code and pseudo stack.
						//..................................................
						bResult = DeallocateMemory(lpCodeTable);
						if (!bResult)
						{
							goto ExtractEnd;
						}
						lpCodeTable = 0;
						bResult = DeallocateMemory(lpPStack);
						if (!bResult)
						{
							goto ExtractEnd;
						}
						lpPStack = 0;
					}
					else
					{
						// Decompress using the zip algorithms.
						//.....................................
						bResult = UnzipMyFile((LPBYTE)&szFileName,hInputFile,
											 (LPBYTE)&szDestination,hOutPutFile);
						if (!bResult)
						{
							goto ExtractEnd;
						}
					}
				}
				// Check the crc32 check value and close out the file
				// after adding the times and attributes.
				//....................................................
				if (bWeHaveLzw)
				{
					dwCheckCrc32 ^= -1;
				}
				if (dwCheckCrc32 != pfhdr.dwFileCrc32)
				{
					SetLastError(IDS_DECOMPINTEGRITYFAILED);
					ErrorProcedure((LPTSTR)&szDestination,IDS_READ,MB_OK);
				}
				else
				{
					dwPassCrc32++;
				}
				bResult = SetFileTime(hOutPutFile,&pfhdr.ftCreation,&pfhdr.ftAccessed,
									  &pfhdr.ftLastWrite);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILETIME,MB_OK);
				}
				bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
				if (!bResult)
				{
					goto ExtractEnd;
				}
				hOutPutFile = 0;

				bResult = SetFileAttributes((LPCTSTR)&szDestination,pfhdr.dwFileAttributes);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDestination,IDS_SETFILEATTR,MB_OK);
				}
				iFilesUnpacked++;
				iNumberOfFiles--;
		
				// Print running stats.
				//.....................
				StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szExtResults,
							    iItemsSelected,dwPassCrc32,iFilesUnpacked);
				SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);			
			}
			NextFile:

			bDiskError = FALSE;

			// If we have extracted all that we selected, quit.
			//.................................................
			if (iNumberOfFiles == 0)
			{
				break;
			}
			// Process the next file in the central directory.
			//................................................
			__asm
			{
				mov		eax,dwHeaderSize
				add		lppfdScratch,eax
			}
			iFilesToProcess--;
		}

	  ExtractStats:

		// Print final stats.
		//...................
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szExtResults,
					    iItemsSelected,dwPassCrc32,iFilesUnpacked);
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

		// Close the original packed file.
		//................................
		bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		if (!bResult)
		{
			goto ExtractEnd;
		}
		hInputFile = 0;

		// Set the position of the progress bar to 100% if we 
		// did not quit or exit with an error
		//...................................................
		if (!bCancelOperation && iFilesUnpacked == iItemsSelected)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
		}
		// Make sure bCancelOperation is set to FALSE.
		//............................................
		bCancelOperation = FALSE;
		bDiskError = FALSE;

		// Stop the avi clip.
		//...................
		if (bAviClipOK)
		{
			bAviClipOK = Animate_Stop(hAviClip);
		}
		// Change the cancel button to ok.
		//................................
		SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

		FlashMyIcon(TRUE);

		// Wait until we close the dialog box to exit.
		//............................................
		while(TRUE)
		{
			CheckForMessages();
			if (bCancelOperation == TRUE)
			{
				break;
			}
		}
	}
	else
	{
		// Delete files from the packed file. If all of the files
		// are selected confirm that we want to delete the whole file.
		//............................................................
		if (iItemsSelected == pfidhdr.iFilesInVault)
		{
			LoadString(hInst,IDS_DELETEPKDFILE,(LPTSTR)&szFormat,sizeof(szFormat));
			StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormat,
						    &szFileName);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szOutBuffer,
								     MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);
			if (iResult == IDNO)
			{
				goto ExtractEnd;
			}
			// We have elected to delete the whole file.
			//..........................................
			bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
			if (!bResult)
			{
				goto ExtractEnd;
			}
			hInputFile = 0;
			DeleteMyFile((LPTSTR)&szFileName);
			bAllDeleted = TRUE;
		}
		else
		{
			// We only have selected files to delete from the
			// packed file. Setup the modeless dialog box for
			// deleting our files.
			//...............................................
			bCancelOperation = FALSE;
			hDialogModeLess = CreateDialog(hInst,TEXT("DELETEPACKEDFILES"),hMainWindow,
										  (DLGPROC)DeletePackedFilesProc);
			if (!hDialogModeLess)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto ExtractEnd;
			}
			// Start the avi clip.
			//....................
			if (bAviClipOK)
			{
				bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
			}
			// Setup to delete the files from the packed file.
			// Create a temporary file to hold the new packed
			// file.
			//................................................
			hBackUpFile = CreateMyFile((LPTSTR)&szBackUpFile,GENERIC_READ | GENERIC_WRITE,0,
									    NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hBackUpFile)
			{
				goto ExtractEnd;
			}
			// Write the file header id to disk. It will be updated
			// when we are done.
			//.....................................................
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
								   &pfidhdr,sizeof(PACKED_FILE_ID_HDR),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto ExtractEnd;
			}
			lppfdScratch = lppfd;

			while(iNumberOfFiles > 0)
			{
				EmptyTheMessageQue();
				if (bCancelOperation == TRUE)
				{
					goto ExtractEnd;
				}

				// Check to see if we delete this file or not.
				//............................................
				if (lppfdScratch->STATE > 0)
				{
					// Display the file name and icon that we are
					// deleting.
					//...........................................
					if (hIcon2)
					{
						DestroyIcon(hIcon2);
						hIcon2 = 0;
					}				
					lpFileExtension = PathFindExtension((LPCTSTR)lppfdScratch->FileName);
					SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
									 (LPCTSTR)lppfdScratch->FileName);
					hIcon2 = FindMyIcon((LPBYTE)lppfdScratch->FileName,lpFileExtension);

					// If we did not find one, use the default.
					//.........................................
					if (!hIcon2)
					{
						hIcon2 = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
					}
					if (hIcon2)
					{
						SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),
								    STM_SETICON,(WPARAM)hIcon2,0);
					}

					EmptyTheMessageQue();

					// We do not copy this file. Read in the file
					// header.
					//...........................................
					bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfhdr,
										  sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);

					// If we did not read in the required number of bytes.
					//....................................................
					if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
					{
						SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
						ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
						goto ExtractEnd;
					}
					if (!bResult)
					{
						goto ExtractEnd;
					}
					pfidhdr.iFilesInVault--;
					pfidhdr.uliTotalSizeOfFiles.QuadPart -= pfhdr.uliFileSize.QuadPart;

					// Read in the file name.
					//.......................
					bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,lpInBuffer,
										  pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

					// If we did not read in the required number of bytes.
					//....................................................
					if (dwBytesRead != pfhdr.wLengthOfFileName)
					{
						SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
						ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
						goto ExtractEnd;
					}
					if (!bResult)
					{
						goto ExtractEnd;
					}
					// Get past the compressed data to the next file
					// header.
					//..............................................
					uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
													 pfhdr.uliCompressedFileSize.QuadPart,
													 FILE_CURRENT);
					if (uli.QuadPart == -1)
					{
						goto ExtractEnd;
					}
				}
				else
				{
					// Do not delete this file. Copy it to the new
					// packed file.
					//............................................
					bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
										  &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);

					// If we did not read in the required number of bytes.
					//....................................................
					if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
					{
						SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
						ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
						goto ExtractEnd;
					}
					if (!bResult)
					{
						goto ExtractEnd;
					}
					bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,&pfhdr,dwBytesRead,
										   &dwBytesWritten,NULL);
					if (!bResult)
					{
						goto ExtractEnd;
					}
					// Read and write the file name.
					//..............................
					bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,lpInBuffer,
										  pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

					// If we did not read in the required number of bytes.
					//....................................................
					if (dwBytesRead != pfhdr.wLengthOfFileName)
					{
						SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
						ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
						goto ExtractEnd;
					}
					if (!bResult)
					{
						goto ExtractEnd;
					}
					bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,lpInBuffer,
										   dwBytesRead,&dwBytesWritten,NULL);
					if (!bResult)
					{
						goto ExtractEnd;
					}
					// Now transfer the compressed data.
					//..................................
					uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;
					while(uli.QuadPart > 0)
					{
						EmptyTheMessageQue();
						if (bCancelOperation == TRUE)
						{
							goto ExtractEnd;
						}
						if (uli.QuadPart > BUFFER_SIZE_IN)
						{
							dwBytesToRead = BUFFER_SIZE_IN;
							uli.QuadPart -= BUFFER_SIZE_IN;
						}
						else
						{
							dwBytesToRead = uli.LowPart;
							uli.QuadPart = 0;
						}
						bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,lpInBuffer,
											  dwBytesToRead,&dwBytesRead,NULL);

						// If we did not read in the required number of 
						// bytes.
						//.............................................
						if (dwBytesRead != dwBytesToRead)
						{
							SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
							ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
							goto ExtractEnd;
						}
						if (!bResult)
						{
							goto ExtractEnd;
						}
						bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,lpInBuffer,
											   dwBytesRead,&dwBytesWritten,NULL);
						if (!bResult)
						{
							goto ExtractEnd;
						}
					}
				}
				// Update the progress bar.
				//.........................
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);

				// Process the next file in the central directory.
				//................................................
				__asm
				{
					mov		eax,dwHeaderSize
					add		lppfdScratch,eax
				}
				iNumberOfFiles--;
			}
			// Write the final file id header back to disk.
			//.............................................
			uli.QuadPart = 0;
			uli.QuadPart = SetMyFilePointer((LPTSTR)&szBackUpFile,hBackUpFile,uli.QuadPart,
											 FILE_BEGIN);
			if (uli.QuadPart == -1)
			{
				goto ExtractEnd;
			}
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,&pfidhdr,
								   sizeof(PACKED_FILE_ID_HDR),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto ExtractEnd;
			}
			// Get the final size of the new packed file.
			//...........................................
			uliFinalFileSize.QuadPart = 0;
			uliFinalFileSize.QuadPart = SetMyFilePointer((LPTSTR)&szBackUpFile,hBackUpFile,
														  uliFinalFileSize.QuadPart,FILE_END);
			if (uliFinalFileSize.QuadPart == -1)
			{
				goto ExtractEnd;
			}
			bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
			if (!bResult)
			{
				goto ExtractEnd;
			}
			hBackUpFile = 0;

			// Close the original packed file.
			//................................
			bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
			if (!bResult)
			{
				goto ExtractEnd;
			}
			hInputFile = 0;

			// Copy the new packed file over the old one.
			//...........................................
			bResult = CopyFile((LPCTSTR)&szBackUpFile,(LPCTSTR)&szFileName,FALSE);
			if (!bResult)
			{
				bCancelOperation = TRUE;
				ErrorProcedure((LPTSTR)&szDestination,IDS_COPYFILE,MB_OK);
			}
			else
			{
				DeleteMyFile((LPTSTR)&szBackUpFile);
			}
			// Set the position of the progress bar to 100% if we 
			// did not quit or exit with an error
			//...................................................
			if (!bCancelOperation)
			{
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,
						   (WPARAM)iTotalFiles,0);
			}
			// Make sure bCancelOperation is set to FALSE.
			//............................................
			bCancelOperation = FALSE;

			// Stop the avi clip.
			//...................
			if (bAviClipOK)
			{
				bAviClipOK = Animate_Stop(hAviClip);
			}
			// Change the cancel button to ok.
			//................................
			SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

			FlashMyIcon(TRUE);

			// Wait until we close the dialog box to exit.
			//............................................
			while(TRUE)
			{
				CheckForMessages();
				if (bCancelOperation == TRUE)
				{
					break;
				}
			}
			bDiskError = FALSE;
		}
	}

	ExtractEnd:

	FlashMyIcon(FALSE);

	Crc32Table(DELETE_TABLE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hPackedOpen)
	{
		CloseHandle(hPackedOpen);
		hPackedOpen = 0;
	}
	if (hPackedEvent)
	{
		CloseHandle(hPackedEvent);
		hPackedEvent = 0;
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
		if (bDiskError)
		{
			DeleteMyFile((LPTSTR)&szDestination);
		}
	}
	if (hBackUpFile)
	{
		CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
		DeleteMyFile((LPTSTR)&szBackUpFile);
		hBackUpFile = 0;
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpCodeTable)
	{
		DeallocateMemory(lpCodeTable);
		lpCodeTable = 0;
	}
	if (lpPStack)
	{
		DeallocateMemory(lpPStack);
		lpPStack = 0;
	}
	// Show the final status of the packed file.
	//..........................................
	if (!bDiskError && !bExtract && !bAllDeleted)
	{
		CopyMemory(&szDestination,&szFileName,MAX_PATH);
		iResult = DialogBox(hInst,TEXT("PACKEDFILESTATUS"),hMainWindow,
						   (DLGPROC)PackedFileStatusProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		}
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for deleting files from a packed file.
//..........................................................
LRESULT CALLBACK DeletePackedFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)iNumberOfFiles);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the packed file to delete files from.
			//........................................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for extracting files from a packed file.
//............................................................
LRESULT CALLBACK ExtractPackedFilesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_STATEMENT1,0);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the progress bar.
			//........................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the packed file to extract files from.
			//.........................................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{			
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}
